/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.CustomNPCsEvent;
import noppes.npcs.blocks.tiles.CustomTileEntityPortal;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.Util;

public class CustomBlockPortal
extends BlockEndPortal
implements ICustomElement {
    public static AxisAlignedBB PORTAL_AABB_0 = new AxisAlignedBB(0.0, 0.26, 0.0, 1.0, 0.74, 1.0);
    public static AxisAlignedBB PORTAL_AABB_1 = new AxisAlignedBB(0.0, 0.0, 0.26, 1.0, 1.0, 0.74);
    public static AxisAlignedBB PORTAL_AABB_2 = new AxisAlignedBB(0.26, 0.0, 0.0, 0.74, 1.0, 1.0);
    public static PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)2);
    public NBTTagCompound nbtData;

    public CustomBlockPortal(Material material, NBTTagCompound nbtBlock) {
        super(material);
        this.nbtData = nbtBlock;
        String name = "custom_" + nbtBlock.func_74779_i("RegistryName");
        this.setRegistryName("customnpcs", name.toLowerCase());
        this.func_149663_c(name.toLowerCase());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0)));
        this.field_149790_y = true;
        this.field_149763_I = 1.0f;
        this.field_149786_r = this.field_149787_q ? 255 : 0;
        this.field_149785_s = !this.field_149764_J.func_76228_b();
        this.func_149711_c(-1.0f);
        this.func_149752_b(6000000.0f);
        if (nbtBlock.func_150297_b("LightLevel", 5)) {
            this.func_149715_a(nbtBlock.func_74760_g("LightLevel"));
        }
        this.func_149647_a(CustomRegisters.tabBlocks);
    }

    public boolean canEntityDestroy(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        return false;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new CustomTileEntityPortal();
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta == 1) {
            return PORTAL_AABB_1;
        }
        if (meta == 2) {
            return PORTAL_AABB_2;
        }
        return PORTAL_AABB_0;
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, 0);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta % 3));
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabBlocks && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Block)this));
        if (tab == CustomRegisters.tabBlocks) {
            Util.instance.sort(items);
        }
    }

    private CustomTileEntityPortal getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (tile instanceof CustomTileEntityPortal && block instanceof CustomBlockPortal && ((CustomBlockPortal)block).getCustomName().equals(this.getCustomName())) {
            return (CustomTileEntityPortal)tile;
        }
        return null;
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof CustomTileEntityPortal) {
            CustomTileEntityPortal adjacent;
            int type;
            int n = type = placer.field_70125_A < -45.0f || placer.field_70125_A > 45.0f ? 0 : 1;
            if (type == 1 && (placer.func_174811_aO() == EnumFacing.EAST || placer.func_174811_aO() == EnumFacing.WEST)) {
                type = 2;
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(type)));
            if (this.nbtData.func_150297_b("RenderData", 10) && this.nbtData.func_74775_l("RenderData").func_150297_b("SecondSpeed", 5)) {
                NBTTagCompound nbtRender = this.nbtData.func_74775_l("RenderData");
                if (nbtRender.func_150297_b("SecondSpeed", 5)) {
                    ((CustomTileEntityPortal)tile).speed = nbtRender.func_74760_g("SecondSpeed");
                    if (((CustomTileEntityPortal)tile).speed < 10.0f) {
                        ((CustomTileEntityPortal)tile).speed = 10.0f;
                    } else if (((CustomTileEntityPortal)tile).speed > 10000.0f) {
                        ((CustomTileEntityPortal)tile).speed = 10000.0f;
                    }
                }
                if (nbtRender.func_150297_b("Transparency", 5)) {
                    ((CustomTileEntityPortal)tile).alpha = nbtRender.func_74760_g("Transparency");
                    if (((CustomTileEntityPortal)tile).alpha < 0.15f) {
                        ((CustomTileEntityPortal)tile).alpha = 0.15f;
                    } else if (((CustomTileEntityPortal)tile).alpha > 1.0f) {
                        ((CustomTileEntityPortal)tile).alpha = 1.0f;
                    }
                }
            }
            if ((adjacent = this.getTile(world, pos.func_177968_d())) == null) {
                for (int i = 0; i < 6; ++i) {
                    switch (i) {
                        case 0: {
                            adjacent = this.getTile(world, pos.func_177968_d());
                            break;
                        }
                        case 1: {
                            adjacent = this.getTile(world, pos.func_177978_c());
                            break;
                        }
                        case 2: {
                            adjacent = this.getTile(world, pos.func_177974_f());
                            break;
                        }
                        case 3: {
                            adjacent = this.getTile(world, pos.func_177976_e());
                            break;
                        }
                        case 4: {
                            adjacent = this.getTile(world, pos.func_177984_a());
                            break;
                        }
                        case 5: {
                            adjacent = this.getTile(world, pos.func_177977_b());
                        }
                    }
                    if (adjacent != null) break;
                }
            }
            if (adjacent != null) {
                CustomTileEntityPortal ctep = adjacent;
                CustomNPCsScheduler.runTack(() -> {
                    TileEntity t = world.func_175625_s(pos);
                    if (t instanceof CustomTileEntityPortal) {
                        if (ctep.posTp[1] > -1) {
                            ((CustomTileEntityPortal)t).posTp[0] = ctep.posTp[0];
                            ((CustomTileEntityPortal)t).posTp[1] = ctep.posTp[1];
                            ((CustomTileEntityPortal)t).posTp[2] = ctep.posTp[2];
                        }
                        if (ctep.posHomeTp[1] > -1) {
                            ((CustomTileEntityPortal)t).posHomeTp[0] = ctep.posHomeTp[0];
                            ((CustomTileEntityPortal)t).posHomeTp[1] = ctep.posHomeTp[1];
                            ((CustomTileEntityPortal)t).posHomeTp[2] = ctep.posHomeTp[2];
                        }
                        ((CustomTileEntityPortal)t).dimensionId = ctep.dimensionId;
                        ((CustomTileEntityPortal)t).homeDimensionId = ctep.homeDimensionId;
                        ((CustomTileEntityPortal)t).speed = ctep.speed;
                        ((CustomTileEntityPortal)t).alpha = ctep.alpha;
                        ((CustomTileEntityPortal)t).updateToClient();
                    }
                }, 250);
            }
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_180634_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        TileEntity tile;
        int id = 0;
        int homeId = 0;
        if (this.nbtData.func_150297_b("DimensionID", 3)) {
            id = this.nbtData.func_74762_e("DimensionID");
        }
        if (this.nbtData.func_150297_b("HomeDimensionID", 3)) {
            homeId = this.nbtData.func_74762_e("HomeDimensionID");
        }
        if ((tile = worldIn.func_175625_s(pos)) instanceof CustomTileEntityPortal) {
            if (DimensionManager.isDimensionRegistered((int)((CustomTileEntityPortal)tile).dimensionId)) {
                id = ((CustomTileEntityPortal)tile).dimensionId;
            }
            if (DimensionManager.isDimensionRegistered((int)((CustomTileEntityPortal)tile).homeDimensionId)) {
                homeId = ((CustomTileEntityPortal)tile).homeDimensionId;
            }
        }
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            id = 0;
        }
        if (!DimensionManager.isDimensionRegistered((int)homeId)) {
            homeId = 0;
        }
        if (!worldIn.field_72995_K && !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU() && entityIn.func_174813_aQ().func_72326_a(state.func_185900_c((IBlockAccess)worldIn, pos).func_186670_a(pos))) {
            CustomNPCsEvent event;
            boolean isHome = worldIn.field_73011_w.getDimension() == id;
            BlockPos p = null;
            if (tile instanceof CustomTileEntityPortal) {
                p = ((CustomTileEntityPortal)tile).getPosTp(isHome);
            }
            if (p == null) {
                WorldServer world = Objects.requireNonNull(entityIn.func_184102_h()).func_71218_a(isHome ? homeId : id);
                p = world.func_180504_m();
                if (p == null) {
                    p = world.func_175694_M();
                }
                if (!world.func_175623_d(p)) {
                    p = world.func_175672_r(p);
                } else if (!world.func_175623_d(p.func_177984_a())) {
                    while (world.func_175623_d(p) && p.func_177956_o() > 0) {
                        p = p.func_177977_b();
                    }
                    if (p.func_177956_o() == 0) {
                        p = world.func_175672_r(p);
                    }
                }
            }
            if (entityIn instanceof EntityPlayerMP) {
                event = EventHooks.onPlayerTeleport((EntityPlayerMP)entityIn, p, pos, isHome ? homeId : id);
                if (!event.isCanceled()) {
                    NoppesUtilPlayer.teleportPlayer((EntityPlayerMP)entityIn, event.pos.getX() + 0.5, event.pos.getY(), event.pos.getZ() + 0.5, event.dimension, entityIn.field_70177_z, entityIn.field_70125_A);
                }
            } else {
                if (entityIn instanceof EntityNPCInterface && ((event = EventHooks.onNpcTeleport((EntityNPCInterface)entityIn, p, pos, isHome ? homeId : id)).isCanceled() || entityIn.field_70128_L)) {
                    return;
                }
                if ((entityIn = Util.instance.travelEntity(CustomNpcs.Server, entityIn, isHome ? homeId : id)) != null) {
                    entityIn.func_70107_b((double)p.func_177958_n() + 0.5, (double)p.func_177956_o(), (double)p.func_177952_p() + 0.5);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState stateIn, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (this.nbtData.func_150297_b("RenderData", 10) && Math.random() < 0.25) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + 0.8f;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            EnumParticleTypes p = EnumParticleTypes.CRIT;
            for (EnumParticleTypes ept : EnumParticleTypes.values()) {
                if (!ept.name().equalsIgnoreCase(this.nbtData.func_74775_l("RenderData").func_74779_i("SpawnParticle"))) continue;
                p = ept;
                break;
            }
            worldIn.func_175688_a(p, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return side == EnumFacing.DOWN && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("BlockType", 1)) {
            return this.nbtData.func_74771_c("BlockType");
        }
        return 5;
    }
}

